/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util.contentadapter;

import com.webcodepro.applecommander.ui.swt.util.ImageCanvas;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.ContentTypeAdapter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;

public class ImageCanvasAdapter
implements ContentTypeAdapter {
    private ImageCanvas imageCanvas;
    private String printJobName;

    public ImageCanvasAdapter(ImageCanvas imageCanvas, String printJobName) {
        this.imageCanvas = imageCanvas;
        this.printJobName = printJobName;
    }

    @Override
    public void print() {
        final Printer printer = SwtUtil.showPrintDialog(this.imageCanvas);
        if (printer == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                printer.startJob(ImageCanvasAdapter.this.getPrintJobName());
                printer.startPage();
                Point dpi = printer.getDPI();
                Image image = ImageCanvasAdapter.this.getImageCanvas().getImage();
                int imageWidth = image.getImageData().width;
                int imageHeight = image.getImageData().height;
                int printedWidth = imageWidth * (dpi.x / 96);
                int printedHeight = imageHeight * (dpi.y / 96);
                GC gc = new GC((Drawable)printer);
                gc.drawImage(image, 0, 0, imageWidth, imageHeight, 0, 0, printedWidth, printedHeight);
                printer.endPage();
                printer.endJob();
                gc.dispose();
                printer.dispose();
            }
        }).start();
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void copy() {
    }

    protected ImageCanvas getImageCanvas() {
        return this.imageCanvas;
    }

    protected String getPrintJobName() {
        return this.printJobName;
    }
}

